<?php
/**
* The template for displaying page
* template name: News Template
*
* @package TSS technology
* @since TSS technology 1.0
*/

get_header();
?>	<!-- BANNER -->
<div class="section banner-page about">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<div class="title-page"><?php the_title(); ?> </div>
					<ol class="breadcrumb">
						<li><a href="<?php echo home_url(); ?>">Home</a></li>
						<li class="active"><?php the_title(); ?></li>
					</ol>
				</div>
			</div>
		</div>
	</div>
	<?php 

	$args = array('post_type'=>'post');

	$qr = new WP_Query($args);

	if($qr->have_posts())
	{ 

	 ?>
	<div class="section why overlap">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
						News
					</h2>
				</div>
			</div>
			<?php while ($qr->have_posts()) {

								$qr->the_post();

								$img_url = wp_get_attachment_url(get_post_thumbnail_id($post->ID),'full');
								$post_date = get_the_date( 'l F j, Y' ); 
				 		?>
				<div class="col-sm-6 col-md-4">
					<!-- BOX 1 -->
					<div class="box-news-1">
						<div class="media gbr">
							<img src="<?php echo $img_url; ?>" alt="" class="img-responsive">
						</div>
						<div class="body">
							<div class="title"><a href="<?php echo  get_permalink($post->ID); ?>" title=""><?php the_title(); ?></a></div>
							<div class="meta">
								<span class="date"><i class="fa fa-clock-o"></i> <?php echo $post_date; ?></span>
								<span class="comments"><i class="fa fa-comment-o"></i>  <?php comments_number( 'no comments', 'one comment', '% comments' ); ?></span>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>

		</div>
	</div>	
<?php } get_footer(); ?>