<?php
/**
* The template for displaying page
* template name: Get With TTS
*
* @package TSS technology
* @since TSS technology 1.0
*/

get_header();
?>	<!-- BANNER -->
<div class="section banner-page about">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<div class="title-page"><?php the_title(); ?> </div>
					<ol class="breadcrumb">
						<li><a href="<?php echo home_url(); ?>">Home</a></li>
						<li class="active"><?php the_title(); ?></li>
					</ol>
				</div>
			</div>
		</div>
	</div>
  
	 
<!-- Get with TTS  -->
	<div class="section why overlap">
		<div class="container">
			<div class="row">
				<div class="col-sm-12 col-md-12">
					<h2 class="section-heading">
					<?php the_title(); ?>	
					</h2>
				</div>
			</div>

				<?php $args = array('post_type'=>'get_with_tts');

		$qr = new WP_Query($args);

		if($qr->have_posts())
		{
	 ?>
				<div class="row no-gutter">
					<?php while ($qr->have_posts()) { 
							$qr->the_post();
							$content = strip_tags(get_the_content());
					 ?>
				<div class="col-sm-6 col-md-4">
					<!-- BOX 1 -->
					<div class="box-icon-3">
						<div class="line-t"></div>
						<div class="icon">
							<div class="fa <?php echo the_field('icon'); ?>"></div>
						</div>
						<div class="body-content">
							<div class="heading"><?php the_title(); ?></div>
							<?php echo substr($content, 0, 60); ?>
							<a href="<?php echo get_permalink($post->ID); ?>" class="readmore">READ MORE</a>
						</div>
						<div class="line-b"></div>
					</div>
				</div>
				<?php } ?>		
				
			</div>
		<?php } ?>

		</div>
	</div>
<?php get_footer(); ?>