<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package TTS-technology
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>


	<!-- Load page -->
	<div class="animationload">
		<div class="loader"></div>
	</div>
	
	<!-- BACK TO TOP SECTION -->
	<a href="#0" class="cd-top cd-is-visible cd-fade-out">Top</a>

	<!-- HEADER -->
    <div class="header">
    	<!-- TOPBAR -->
		<div class="topbar">
			<div class="container">
				<div class="row">
					<div class="col-sm-5 col-md-6">
						<div class="topbar-left">
							<div class="welcome-text">
							We help the world growing since ...
							</div>
						</div>
					</div>
					<div class="col-sm-7 col-md-6">
						<div class="topbar-right">
							<!-- <ul class="topbar-menu">
								<li><a href="career.html" title="Career">Career</a></li>
								<li><a href="contact-feedback.html" title="Give Feedback">Give Feedback</a></li>
								<li><a href="Contact.html" title="Contact Us">Contact Us</a></li>
							</ul> -->
							<ul class="topbar-sosmed">
							<li>
								<a href="#"><i class="fa fa-facebook"></i></a>
							</li>
							<li>
								<a href="#"><i class="fa fa-twitter"></i></a>
							</li>
							<li>
								<a href="#"><i class="fa fa-google-plus"></i></a>
							</li>
							<li>
								<a href="#"><i class="fa fa-youtube"></i></a>
							</li>
							<li>
								<a href="#"><i class="fa fa-pinterest"></i></a>
							</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- TOPBAR LOGO SECTION -->
		<div class="topbar-logo">
			<div class="container">
				

				<div class="contact-info">
					<!-- INFO 1 -->
					<div class="box-icon-1">
						<div class="icon">
							<div class="fa fa-envelope-o"></div>
						</div>
						<?php $email = myprefix_get_theme_option('email'); 
							$mobile = myprefix_get_theme_option('mobile');
						?>
						<div class="body-content">
							<div class="heading"> <?php echo $email; ?></div>
							 
						</div>
					</div>
					<!-- INFO 2 -->
					<div class="box-icon-1">
						<div class="icon">
							<div class="fa fa-phone"></div>
						</div>
						<div class="body-content">
							<div class="heading"><?php echo $mobile; ?></div>
							 
						</div>
					</div>
					<!-- INFO 3 -->
					 

				</div>
			</div>
		</div>

		<!-- NAVBAR SECTION -->
		<div class="navbar navbar-main">
			<div class="container container-nav">
				<div class="rowe">		
					<div class="navbar-header">
						<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</button>		
					</div>
					<?php 
						$custom_logo_id = get_theme_mod('custom_logo');
						$image = wp_get_attachment_image_src($custom_logo_id, 'full');
					?>
					<a class="navbar-brand" href="<?php echo home_url(); ?>">
						<img src="<?php echo $image[0]; ?>" alt="" />
					</a>
					<nav class="navbar-collapse collapse">
						<?php
							wp_nav_menu( array(
								'theme_location' => 'menu-1',
								'container' => 'ul',
								'menu_class' => 'nav navbar-nav navbar-left'
							) );
						?> 
					</nav>
						
				</div>
			</div>
	    </div>

    </div>